varying vec2 		texcoord;
varying float		dist;
uniform sampler2D 	tex;
//uniform sampler2D 	noiseTex;
uniform vec4		ambientColor;	// ambient  * material color
varying vec4		diffuse;		// diffuse color * material color
varying vec4		fog;
//varying float		alphaFade;

// CAUSTICS EFFECT
uniform sampler2D	causticsTex;
uniform vec4		LTM0,
					LTM1,
					LTM3;
				
uniform vec4	LTM0b,
				LTM1b,
				LTM3b;
			
uniform vec4	LTM0c,
				LTM1c,
				LTM3c;
varying vec4	eyepos;
uniform vec3	SUN;

#ifdef _HEIGHTMAP_

	uniform sampler2D	cmask;	
	varying vec2 		texcoord2;
	
#endif

void main()
{
	vec4 color=texture2D(tex,texcoord.st);

	// CAUSTICS /////////////////////////////////
	vec4	XYproj;	
	vec3 	projcoords;
	
	XYproj.x = dot(eyepos,LTM0);
	XYproj.y = dot(eyepos,LTM1);
	XYproj.w = dot(eyepos,LTM3);
	projcoords.xy=(XYproj.xy/XYproj.w);
	vec2 coords0=projcoords.xy;//*220.0 - ofs;
	
	XYproj.x = dot(eyepos,LTM0b);
	XYproj.y = dot(eyepos,LTM1b);
	XYproj.w = dot(eyepos,LTM3b);
	projcoords.xy=(XYproj.xy/XYproj.w);
	vec2 coords1=projcoords.xy;//*120.0 + ofs;
	
	XYproj.x = dot(eyepos,LTM0c);
	XYproj.y = dot(eyepos,LTM1c);
	XYproj.w = dot(eyepos,LTM3c);
	projcoords.xy=(XYproj.xy/XYproj.w);
	vec2 coords2=projcoords.xy;//*120.0 + ofs;
	
	float c0,c1,c2;
	c0=texture2D(causticsTex,coords0.xy).r;
	c1=texture2D(causticsTex,coords1.xy).r;
	c2=texture2D(causticsTex,coords2.xy).r;
	
	vec3 CR=SUN*( (c0*c1*c2*3.0) + (c0+c1+c2) )*color.xyz*1.5;
	
	////////////////////////////////////////////////////
	
	#ifdef _HEIGHTMAP_
		
		color*=texture2D(cmask,texcoord2.st);
		
	#else
	
		/*float alpha=texture2D(noiseTex,texcoord.st).r;
		if(alpha>1.0)//alphaFade)
			discard;*/
	
	#endif
	
	if(dist<=0.0)
	{
		discard;
	}
	else
	{
		// convert normal to eye space
		gl_FragColor.xyz=mix(fog.rgb,color.xyz*ambientColor.xyz + color.xyz*diffuse.xyz + CR,fog.a);
		gl_FragColor.a=color.a;
	}
}
